% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeLoci.R
\name{summarizeLoci}
\alias{summarizeLoci}
\title{Locus Summaries}
\usage{
summarizeLoci(g, by.strata = FALSE, ...)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{by.strata}{logical. If \code{TRUE}, return a list of summary matrices 
for each stratum.}

\item{...}{arguments to be passed on to summary functions.}
}
\value{
A matrix with rows for each locus and columns containing summaries of:
\describe{
  \item{\code{num.genotyped}}{The number of samples genotyped}
  \item{\code{prop.genotyped}}{The proportion of samples genotyped}
  \item{\code{num.alleles}}{The number of alleles in the locus}
  \item{\code{allelic.richness}}{The allelic richness of the locus}
  \item{\code{prop.unique.alleles}}{Proportion of alleles found in a single sample}
  \item{\code{expt.heterozygosity}}{Expected heterozygosity}
  \item{\code{obsvd.heterozygosity}}{Observed heterozygosity}
}
}
\description{
Compile standard by-locus summaries.
}
\examples{
data(msats.g)
msats.g <- stratify(msats.g, "fine")

summarizeLoci(msats.g)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

