% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propUniqueAlleles.R
\name{propUniqueAlleles}
\alias{propUniqueAlleles}
\title{Proportion Unique Alleles}
\usage{
propUniqueAlleles(g)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}
}
\value{
a vector of the proportion of unique (occuring only in one individual) 
  alleles for each locus.
}
\description{
Calculate the proportion of alleles that are unique.
}
\examples{
data(dolph.strata)
data(dolph.seqs)
strata <- dolph.strata$fine
names(strata) <- dolph.strata$ids
dloop <- sequence2gtypes(dolph.seqs, strata, seq.names = "dLoop")
dloop <- labelHaplotypes(dloop)$gtypes

propUniqueAlleles(dloop)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

