% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{is.row.names}
\alias{is.row.names}
\title{Test for `row.names`}
\usage{
is.row.names(nm, x)
}
\arguments{
\item{nm}{character vector.}

\item{x}{object whose row.names are desired to be tested.}
}
\value{
TRUE for every element of `nm` that is a row.name of x and FALSE otherwise.
The structure is a logical vector with length = length(`nm`) and names = `nm`.
See details for special cases.
}
\description{
\code{is.row.names} returns whether elements of a character vector are row.names of an object.
}
\details{
If the object does not have any row.names, then the function will return `FALSE`
for each element of the character vector. As a reminder, \code{row.names} does not
respond to a manually added "row.names" attribute (e.g., to a vector). If this is
tried, then \code{is.row.names} will return `FALSE` for each element `nm`.
}
\examples{
data("mtcars")
is.row.names(x = mtcars, nm = c("Mazda RX4","mazda RX4"))
}
