% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node-funs.R
\name{sln_add_node}
\alias{sln_add_node}
\title{Add node to spatial lines object}
\usage{
sln_add_node(sln, p)
}
\arguments{
\item{sln}{A spatial lines (\code{sfNetwork}) object created by \code{SpatialLinesNetwork}}

\item{p}{A point represented by an \code{sf} object the will split the \code{route}}
}
\description{
Add node to spatial lines object
}
\examples{
sample_routes <- routes_fast_sf[2:6, NULL]
sample_routes$value <- rep(1:3, length.out = 5)
rnet <- overline2(sample_routes, attrib = "value")
sln <- SpatialLinesNetwork(rnet)
p <- sf::st_sfc(sf::st_point(c(-1.540, 53.826)), crs = sf::st_crs(rnet))
sln_nodes <- sln2points(sln)
sln_new <- sln_add_node(sln, p)
route <- route_local(sln_new, p, sln_nodes[9, ])
plot(sln)
plot(sln_nodes, pch = as.character(1:nrow(sln_nodes)), add = TRUE)
plot(route$geometry, lwd = 9, add = TRUE)
}
