% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base64.R
\name{encode64}
\alias{encode64}
\alias{decode64}
\title{Base64 encoding and decoding}
\usage{
encode64(x, char62 = "-", char63 = "_", pad = TRUE)

decode64(x, char62 = "-", char63 = "_")
}
\arguments{
\item{x}{A string or vector of strings to encode/decode}

\item{char62}{Character to use for the 62nd index}

\item{char63}{Character to use for the 63rd index}

\item{pad}{Logical, indicating if strings should be padded with
\code{=} characters (as RFC 4648 requires)}
}
\description{
Base64 encoding.  By default uses the RFC 4648 dialect (file/url
encoding) where characters 62 and 63 are "-" and "_".  Pass in "+"
and "/" to get the RFC 1421 variant (as in other R packages that
do base64 encoding).
}
\examples{
x <- encode64("hello")
x
decode64(x)

# Encoding things into filename-safe strings is the reason for
# this function:
encode64("unlikely/to be @ valid filename")
}
