% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/willoughby2006eqs.R
\name{calc_R1}
\alias{calc_R1}
\title{Calculate radius to start of transition region}
\usage{
calc_R1(Rmax, xi)
}
\arguments{
\item{Rmax}{Numeric vector of the radius at which the maximum wind occurs,
in kilometers}

\item{xi}{A numeric value with the \eqn{\xi} value determined by
\code{\link{solve_for_xi}}}
}
\value{
A numeric vector with the estimated value of \eqn{R_1}, a parameter
   required for the Willoughby wind model.
}
\description{
Once you've solved for \eqn{\xi}, this function uses this value and the estimated
\eqn{R_{max}}{Rmax} to determine \eqn{R1}, the radius from the storm center to the start of
the transition region.
}
\details{
This function is calculating the equation:

   \deqn{R_1 = R_{max} - \xi(R_2 - R_1)}{
   R1 = Rmax - \xi(R2 - R1)}

   where:
   \itemize{
     \item{\eqn{R_1}{R1}: A parameter for the Willoughby wind model (radius to
       start of transition region)}
     \item{\eqn{R_{max}}{Rmax}: Radius (in kilometers) to highest winds}
     \item{\eqn{R_2 - R_1}{R2 - R1}: Width of the transition region. This is
       assumed to be 25 kilometers if \eqn{R_{max}}{Rmax} is greater than
       20 kilometers and 15 kilometers otherwise.}
   }
}
\references{
Willoughby HE, Darling RWR, and Rahn ME. 2006. Parametric representation
of the primary hurricane vortex. Part II: A new family of sectionally
continuous profiles. Monthly Weather Review 134(4):1102-1120.
}
