% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/willoughby2006eqs.R
\name{will10c}
\alias{will10c}
\title{Calculate A for Willoughby model}
\usage{
will10c(vmax_gl, tclat)
}
\arguments{
\item{vmax_gl}{Numeric vector of the tangential wind component of the maximum
gradient wind speed, in meters per second}

\item{tclat}{Numeric vector of the absolute value of latitude, in degrees.}
}
\value{
A numeric vector that is a parameter required for the Willoughby
   model.
}
\description{
Calculates \eqn{A}, a paramter for the Willoughby wind model, using equation 10c
(Willoughby et al. 2006).
}
\details{
This function calculates \eqn{A} using equation 10c (Willoughby et al.
   2006):

   \deqn{A = 0.0696 + 0.0049 V_{max,G} - 0.0064 \phi}{
   A = 0.0696 + 0.0049 vmax_gl - 0.0064 \phi}

   where:
   \itemize{
     \item{\eqn{A}: Parameter for the Willoughby wind model (any value
         of A calculated as negative is re-set to 0)}
     \item{\eqn{V_{max,G}}{vmax_gl}: Tangential component of the maximum
           gradient-level sustained wind speed (in m / s)}
     \item{\eqn{\phi}: Latitude, in decimal degrees}
   }
   Any negative values of \eqn{A} are reset to 0.
}
\references{
Willoughby HE, Darling RWR, and Rahn ME. 2006. Parametric representation
of the primary hurricane vortex. Part II: A new family of sectionally
continuous profiles. Monthly Weather Review 134(4):1102-1120.
}
