% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latlon_helpers.R
\name{calc_bearing}
\alias{calc_bearing}
\title{Calculate bearing from one location to another}
\usage{
calc_bearing(tclat_1, tclon_1, tclat_2, tclon_2)
}
\arguments{
\item{tclat_1}{A numeric vector giving latitude of the first location
(degrees)}

\item{tclon_1}{A numeric vector giving longitude of the first location
(degrees). This value should be expressed as a positive value for Western
hemisphere longitudes.}

\item{tclat_2}{A numeric vector giving latitude of the second location
(degrees)}

\item{tclon_2}{A numeric vector giving longitude of the second location
(degrees). This value should be expressed as a positive value for Western
hemisphere longitudes.}
}
\value{
A numeric vector giving the direction of the second location from the first location,
   in degrees. A direction of 0 degrees indicates the second location is
   due east of the first, 90 degrees indicates the second location is due
   north of the first, etc.
}
\description{
Calculates the bearing of a second location, as seen from
the first location, based on latitude and longitude coordinates for both
locations.
}
\details{
This function uses the following equations to calculate the bearing
   from one latitude-longitude pair to another:

   \deqn{S = cos(\phi_2) * sin(L_1 - L_2)}{
   S = cos(\phi2) * sin(L1 - L1)}

   \deqn{C = cos(\phi_1) * sin(\phi_2) - sin(\phi_1) * cos(\phi_2) * cos(L_1 - L_2)}{
   C = cos(\phi1) * sin(\phi2) - sin(\phi1) * cos(\phi2) * cos(L1 - L2)}

   \deqn{\theta = atan2(S, C) * \frac{180}{\pi} + 90}

   where:
   \itemize{
     \item{\eqn{\phi_1}{\phi1}: Latitude of first location, in radians}
     \item{\eqn{L_1}{L1}: Longitude of first location, in radians}
     \item{\eqn{\phi_2}{\phi2}: Latitude of second location, in radians}
     \item{\eqn{L_2}{L2}: Longitude of second location, in radians}
     \item{\eqn{S, C}: Intermediary results}
     \item{\eqn{\theta}: Direction of the storm movement, in degrees}
   }

   In cases where this equation results in values below 0 degrees or above
   360 degrees, the function applies modular arithmetic to bring the value
   back within the 0--360 degree range.
}

