% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findconst.bin.R
\name{findconst.bin}
\alias{findconst.bin}
\title{Search for Calibration Value (Binary Data)}
\usage{
findconst.bin(ns, p0, alpha, type, l, u, iter = 50, param)
}
\arguments{
\item{ns}{A vector of sample sizes at which sequential testing is performed}

\item{p0}{The toxicity probability under the null hypothesis}

\item{alpha}{The desired type I error / false positive rate for the stopping rule}

\item{type}{The method used for constructing the stopping rule}

\item{l}{Lower starting value of bracket for calibration constant}

\item{u}{Upper starting value of bracket for calibration constant}

\item{iter}{The number of iterations used to search for the boundary}

\item{param}{Extra parameter(s) needed for certain stopping rule methods. For binomial Wang-Tsiatis tests, this is the Delta parameter. For the Geller et al. method, this is the pair of hyperparameters (a,b) for the beta prior on the toxicity probability. For Chen and Chaloner's method, this is the pair of hyperparameters (a,b) for the beta prior on the toxicity probability, the targeted alternative toxicity probability p1, and the threshold nu for the posterior probability that p > p1. For modified SPRT, this is the targeted alternative toxicity probability p1.}
}
\value{
The calibration constant used for subsequent stopping boundary calculation
}
\description{
Internal workhorse function to calculate the calibration constant value that attains level alpha for given method
}
