% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rule.R
\name{plot.rule}
\alias{plot.rule}
\title{Plot Stopping Rule}
\usage{
\method{plot}{rule}(x, ...)
}
\arguments{
\item{x}{A rule object, being a matrix with two columns: the sample sizes at which sequential testing is performed, and their corresponding rejection boundaries}

\item{...}{Other options to be passed to generic \code{plot} function}
}
\value{
No return value; function solely generates a plot
}
\description{
Display a stopping rule graphically as a curve
}
\examples{
# Binomial Pocock test in 50 patient cohort at 10\% level, expected toxicity rate of 20\%
poc_rule = calc.rule(ns=1:50,p0=0.20,type="Pocock",alpha=0.10)

# Plot stopping boundary with smoothing
plot(poc_rule,col="blue")
}
