% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.stpm.R
\name{plot.stpm}
\alias{plot.stpm}
\title{Plot a \code{stpm} object}
\usage{
\method{plot}{stpm}(x, ...)
}
\arguments{
\item{x}{An object of class \code{stpm}}

\item{...}{additional unused argument}
}
\description{
This function plots the marked point pattern stored in the \code{stpm} object
 given in input,
in a three panel plot representing the 3Dplot of the coordinates, and the
mark values.
}
\examples{

\dontrun{

df <- data.frame(cbind(runif(100), runif(100), runif(100), rpois(100, 15),
rpois(100, 30)))

stpm1 <- stpm(df)

plot(stpm1)

## Categorical marks

dfA <- data.frame(x = runif(100), y = runif(100), t = runif(100), 
                  m1 = rnorm(100), m2 = rep(c("C"), times = 100))
dfB <- data.frame(x = runif(50), y = runif(50), t = runif(50), 
                  m1 = rnorm(25), m2 = rep(c("D"), times = 50))

stpm2 <- stpm(rbind(dfA, dfB), names = c("continuous", "dichotomous"))

plot(stpm2)
}

}
\seealso{
\link{stppm}
}
\author{
Nicoletta D'Angelo
}
