% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_svdraws.R
\name{extractors}
\alias{extractors}
\alias{para}
\alias{latent}
\alias{latent0}
\alias{priors}
\alias{thinning}
\alias{runtime}
\alias{svbeta}
\alias{observations}
\alias{vola}
\alias{svtau}
\alias{sampled_parameters}
\alias{predy}
\alias{predlatent}
\alias{predvola}
\title{Common Extractors for 'svdraws' and 'svpredict' Objects}
\usage{
para(x, chain = "concatenated")

latent0(x, chain = "concatenated")

latent(x, chain = "concatenated")

vola(x, chain = "concatenated")

svbeta(x, chain = "concatenated")

svtau(x, chain = "concatenated")

priors(x)

thinning(x)

runtime(x)

sampled_parameters(x)

predy(y, chain = "concatenated")

predlatent(y, chain = "concatenated")

predvola(y, chain = "concatenated")
}
\arguments{
\item{x}{\code{svdraws} object.}

\item{chain}{\emph{optional} either a positive integer or the string
\code{"concatenated"} (default) or the string \code{"all"}.}

\item{y}{\code{svpredict} object.}
}
\value{
The return value depends on the actual funtion.
\item{para(x, chain = "concatenated")}{extracts the parameter draws.}
\item{latent(x, chain = "concatenated")}{extracts the latent contemporaneous
log-volatility draws.}
\item{latent0(x, chain = "concatenated")}{extracts the latent initial log-volatility draws.}
\item{svbeta(x, chain = "concatenated")}{extracts the linear regression coefficient draws.}
\item{svtau(x, chain = "concatenated")}{extracts the tau draws.}
\item{vola(x, chain = "concatenated")}{extracts standard deviation draws.}
\item{priors(x)}{extracts the prior
parameters used and returns them in a \code{prior_spec} object as generated by
\link{specify_priors}.}
\item{thinning(x)}{extracts the thinning parameters used and returns them in
a \code{list}.}
\item{runtime(x)}{extracts the runtime and returns it as a
\code{proc_time} object.}
\item{sampled_parameters(x)}{returns the names of time independent model
parameters that were actually sampled by \code{svsample}.}
\item{predlatent(y, chain = "concatenated")}{extracts the predicted latent contemporaneous
log-volatility draws.}
\item{predvola(y, chain = "concatenated")}{extracts predicted standard deviation draws.}
\item{predy(y, chain = "concatenated")}{extracts the predicted observation draws.}
Functions that have input parameter \code{chain} return
an \code{mcmc.list} object if \code{chain=="all"} and
return an \code{mcmc} object otherwise. If \code{chain} is
an integer, then the specified chain is selected from
all chains. If \code{chain} is \code{"concatenated"},
then all chains are merged into one \code{mcmc} object.
}
\description{
Some simple extractors returning the corresponding element of an
\code{svdraws} and \code{svpredict} object.
}
\examples{
# Simulate data
sim <- svsim(150)

# Draw from vanilla SV
draws <- svsample(sim, draws = 2000)

## Summarize all parameter draws as a merged mcmc object
summary(para(draws))
## Extract the draws as an mcmc.list object
para(draws, chain = "all")

\donttest{
## Further short examples
summary(latent0(draws))
summary(latent(draws))
summary(vola(draws))
sampled_parameters(draws)
priors(draws)

# Draw 3 independent chains from heavy-tailed and asymmetric SV with AR(2) structure
draws <- svsample(sim, draws = 20000, burnin = 3000,
                  designmatrix = "ar2",
                  priornu = 0.1, priorrho = c(4, 4),
                  n_chains = 3)

## Extract beta draws from the second chain
svbeta(draws, chain = 2)
## ... tau draws from all chains merged/concatenated together
svtau(draws)
## Create a new svdraws object from the first and third chain
second_chain_excluded <- draws[c(1, 3)]

# Draw from the predictive distribution
pred <- predict(draws, steps = 2)

## Extract the predicted observations as an mcmc.list object
predicted_y <- predy(pred, chain = "all")
## ... the predicted standard deviations from the second chain
predicted_sd <- predvola(pred, chain = 2)
## Create a new svpredict object from the first and third chain
second_chain_excluded <- pred[c(1, 3)]
}

}
\seealso{
\link{specify_priors}, \link{svsample}, \link{predict.svdraws}
}
\keyword{utilities}
