#' Lookup Tables Used for Categorization of Problem Codes
#'
#' @description Any data object from the \code{stlcsb} package that starts with \code{cat_}
#'     is a lookup table. These tables were hand-made - contact the package
#'     maintainers with questions or concerns. These tables are used internally
#'     in any function that categorizes by problem code. They are available to the user
#'     as a matter of convenience and transparency.
#'
#' @return A named character vector listing the specific problem codes associated with
#'     each category.
#'
#' @name cat
NULL

#' @rdname cat
"cat_admin"
#' @rdname cat
"cat_animal"
#' @rdname cat
"cat_construction"
#' @rdname cat
"cat_debris"
#' @rdname cat
"cat_degrade"
#' @rdname cat
"cat_disturbance"
#' @rdname cat
"cat_event"
#' @rdname cat
"cat_health"
#' @rdname cat
"cat_landscape"
#' @rdname cat
"cat_law"
#' @rdname cat
"cat_maintenance"
#' @rdname cat
"cat_nature"
#' @rdname cat
"cat_road"
#' @rdname cat
"cat_sewer"
#' @rdname cat
"cat_traffic"
#' @rdname cat
"cat_vacant"
#' @rdname cat
"cat_waste"
