% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot-themes.R
\name{theme_steve}
\alias{theme_steve}
\alias{theme_steve_web}
\alias{post_bg}
\title{Steve's Preferred \pkg{ggplot2} Themes and Assorted Stuff}
\usage{
theme_steve(...)

theme_steve_web(...)

post_bg(...)
}
\arguments{
\item{...}{optional stuff, but don't put anything in here. You won't need it.}
}
\value{
\code{post_bg()} takes a \pkg{ggplot2} plot and changes the background to have a color of
"#fdfdfd". \code{theme_steve()} takes a \pkg{ggplot2} plot and formats it to approximate
\code{theme_bw()} from \pkg{ggplot2}, but with some other tweaks. \code{theme_steve_web()} extends
\code{theme_steve()} to add custom fonts, notably "Open Sans" and "Titillium Web". In all cases, these
functions take a \pkg{ggplot2} plot and return another \pkg{ggplot2} plot, but with some cosmetic
changes.
}
\description{
\code{theme_steve()} was a preferred theme of mine a few years ago. It is
basically \code{theme_bw()} from \pkg{ggplot2} theme, but with me
tweaking a few things. I've since moved to \code{theme_steve_web()} for most things
now, prominently on my website. It incorporates the "Open Sans" and "Titillium Web"
fonts that I like so much. \code{post_bg()} is for changing the backgrounds on
plots to better match my website for posts that I write.
}
\details{
\code{theme_steve_web()} depends on having the fonts installed on your end.
It's ultimately optional for you to have them.
}
\examples{
\dontrun{
library(ggplot2)

ggplot(mtcars, aes(x = mpg, y = hp)) +
  geom_point() + theme_steve() +
  labs(title = "A ggplot2 Plot from the Motor Trend Car Road Tests Data",
  subtitle = "We've all seen this plot over a hundred times.",
  caption = "Data: ?mtcars in {datasets} in base R.")

ggplot(mtcars, aes(x = mpg, y = hp)) +
  geom_point() + theme_steve_web() +
  labs(title = "A ggplot2 Plot from the Motor Trend Car Road Tests Data",
  subtitle = "Notice the prettier fonts, if you have them.",
  caption = "Data: ?mtcars in {datasets} in base R.")

ggplot(mtcars, aes(x = mpg, y = hp)) +
  geom_point() + theme_steve_web() +
  post_bg() +
  labs(title = "A ggplot2 Plot from the Motor Trend Car Road Tests Data",
  subtitle = "Notice the slight change in background color",
  caption = "Data: ?mtcars in {datasets} in base R.")
}
}
\seealso{
[ggplot2::theme]
}
