% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation_results-class.R
\name{simulation}
\alias{simulation}
\title{Run a simulation}
\usage{
simulation(
  landscape,
  population_dynamics,
  habitat_dynamics = list(),
  demo_stochasticity = c("full", "none"),
  timesteps = 3,
  replicates = 1,
  verbose = TRUE,
  future.globals = list()
)
}
\arguments{
\item{landscape}{a \link[steps]{landscape} object representing the initial habitat and
population}

\item{population_dynamics}{a \link[steps]{population_dynamics} object describing how
population changes over time}

\item{habitat_dynamics}{optional list of functions to modify the landscape at
each timestep - see \link[steps]{habitat_dynamics_functions}}

\item{demo_stochasticity}{how should population rounding occur, if at all -
"full" uses a multinomial draw to return rounded cell populations (default)
whilst "none" returns non-integer cell populations (no rounding). Note, this
parameter specification is used consistently throughout all functions in a
simulation.}

\item{timesteps}{number of timesteps used in one simulation}

\item{replicates}{number of simulations to perform}

\item{verbose}{print messages and progress to console? (default is TRUE)}

\item{future.globals}{a list of custom functions, and objects called by the functions,
that a user has created in the global environment for use in a simulation. Note this
is only required when running simulations in parallel (e.g. plan(multisession)).}
}
\value{
An object of class \code{simulation_results}
}
\description{
A simulation changes landscape objects based on selected dynamics over a
specified number of timesteps.
}
\examples{

\dontrun{
ls <- landscape(population = egk_pop, suitability = egk_hab, carrying_capacity = egk_k)

pd <- population_dynamics(change = growth(egk_mat),
                          dispersal = kernel_dispersal(max_distance = 2000,
                                        dispersal_kernel = exponential_dispersal_kernel(
                                          distance_decay = 1000)),
                          density_dependence = ceiling_density())

# Run a simulation with full demographic stochasticity and without any habitat
# dynamics for tewnty timesteps.
sim <- simulation(landscape = ls,
                  population_dynamics = pd,
                  habitat_dynamics = NULL,
                  timesteps = 20)
}
}
