% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stcp.R
\name{Stcp}
\alias{Stcp}
\title{Stcp Class}
\description{
Stcp class supports a unified framework for sequential tests and change
detection algorithms for streams of univariate (sub-)Gaussian, binary,
and bounded random variables.
}
\examples{
# Sequential Normal mean test H0: mu <= 0
# Initialize stcp object for this test.
stcp <- Stcp$new(method = "ST",
                 family = "Normal",
                 alternative = "greater",
                 threshold = log(1 / 0.05),
                 m_pre = 0)

# Update the observations
obs <- c(1.0, 3.0, 2.0)
stcp$updateLogValuesUntilStop(obs)

# Check whether the sequential test is stopped
stcp$isStopped() # TRUE

# Check when the test was stopped
stcp$getStoppedTime() # 3

# Although the number of obervaions was 4, the test was stopped at 3.
stcp$getTime() # 3

# Get the log value of the mixutre of e-values at the current time (3)
stcp$getLogValue() # 4.425555

# ...which is higher than the threshold log(1 / 0.05) ~ 2.996
stcp$getThreshold() # 2.995732

# Reset the test object
stcp$reset()

# Rerun the test but, at this time, we track updated log values
log_values <- stcp$updateAndReturnHistories(obs)
print(log_values) # 0.1159777 2.7002207 4.4255551 1.9746508

# Again, the test was stopped at 3rd observation
stcp$getStoppedTime() # 3

# But, at this time, log values were evaluated until the 4th observation.
stcp$getTime() # 4

# Print overall summary
stcp # or stcp$print() or print(stcp)
# stcp Model:
#   - Method:  ST
# - Family:  Normal
# - Alternative:  greater
# - Alpha:  0.05
# - m_pre:  0
# - Num. of mixing components:  55
# - Obs. have been passed:  4
# - Current log value:  1.974651
# - Is stopped before:  TRUE
# - Stopped time:  3

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Stcp-new}{\code{Stcp$new()}}
\item \href{#method-Stcp-print}{\code{Stcp$print()}}
\item \href{#method-Stcp-getWeights}{\code{Stcp$getWeights()}}
\item \href{#method-Stcp-getLambdas}{\code{Stcp$getLambdas()}}
\item \href{#method-Stcp-getLogValue}{\code{Stcp$getLogValue()}}
\item \href{#method-Stcp-getThreshold}{\code{Stcp$getThreshold()}}
\item \href{#method-Stcp-isStopped}{\code{Stcp$isStopped()}}
\item \href{#method-Stcp-getTime}{\code{Stcp$getTime()}}
\item \href{#method-Stcp-getStoppedTime}{\code{Stcp$getStoppedTime()}}
\item \href{#method-Stcp-reset}{\code{Stcp$reset()}}
\item \href{#method-Stcp-updateLogValues}{\code{Stcp$updateLogValues()}}
\item \href{#method-Stcp-updateLogValuesUntilStop}{\code{Stcp$updateLogValuesUntilStop()}}
\item \href{#method-Stcp-updateAndReturnHistories}{\code{Stcp$updateAndReturnHistories()}}
\item \href{#method-Stcp-updateLogValuesByAvgs}{\code{Stcp$updateLogValuesByAvgs()}}
\item \href{#method-Stcp-updateLogValuesUntilStopByAvgs}{\code{Stcp$updateLogValuesUntilStopByAvgs()}}
\item \href{#method-Stcp-updateAndReturnHistoriesByAvgs}{\code{Stcp$updateAndReturnHistoriesByAvgs()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stcp-new"></a>}}
\if{latex}{\out{\hypertarget{method-Stcp-new}{}}}
\subsection{Method \code{new()}}{
Create a new Stcp object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stcp$new(
  method = c("ST", "SR", "CU", "GLRCU"),
  family = c("Normal", "Ber", "Bounded"),
  alternative = c("two.sided", "greater", "less"),
  threshold = log(1/0.05),
  m_pre = 0,
  delta_lower = 0.1,
  delta_upper = NULL,
  weights = NULL,
  lambdas = NULL,
  k_max = 1000
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{Method of the sequential procedure.
\itemize{
\item ST: Sequential test based on a mixture of E-values.
\item SR: Sequential change detection based on e-SR procedure.
\item CU: Sequential change detection based on e-CUSUM procedure.
\item GLRCU: Sequential change detection based on GLR-CUSUM procedure.
}}

\item{\code{family}}{Distribution of underlying univariate observations.
\itemize{
\item Normal: (sub-)Gaussian with sigma = 1.
\item Ber: Bernoulli distribution on \{0,1\}.
\item Bounded: General bounded distribution on [0,1]
}}

\item{\code{alternative}}{Alternative / post-change mean space
\itemize{
\item two.sided: Two-sided test / change detection
\item greater: Alternative /post-change mean is greater than null / pre-change one
\item less:  Alternative /post-change mean is less than null / pre-change one
}}

\item{\code{threshold}}{Stopping threshold. We recommend to use log(1/alpha)
for "ST" and "SR" methods where alpha is a testing level or 1/ARL.
for "CU" and "GRLCU", we recommend to tune the threshold by using
domain-specific sampler to hit the target ARL.}

\item{\code{m_pre}}{The boundary of mean parameter in null / pre-change space}

\item{\code{delta_lower}}{Minimum gap between null / pre-change space and
alternative / post-change one. It must be strictly positive for ST, SR and CU.
Currently, GLRCU does not support the minimum gap, and this param will be ignored.}

\item{\code{delta_upper}}{Maximum gap between null / pre-change space and
alternative / post-change one. It must be strictly positive for ST, SR and CU.
Currently, GLRCU does not support the maximum gap, and this param will be ignored.}

\item{\code{weights}}{If not null, the input weights will be used to initialize Stcp object.}

\item{\code{lambdas}}{If not null, the input lambdas will be used to initialize Stcp object.}

\item{\code{k_max}}{Positive integer to determine the maximum number of baselines.
For GLRCU method, it is used as the lookup window size for GLRCU statistics.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Stcp} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stcp-print"></a>}}
\if{latex}{\out{\hypertarget{method-Stcp-print}{}}}
\subsection{Method \code{print()}}{
Print summary of Stcp object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stcp$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stcp-getWeights"></a>}}
\if{latex}{\out{\hypertarget{method-Stcp-getWeights}{}}}
\subsection{Method \code{getWeights()}}{
Return weights of mixture of e-values / e-detectors.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stcp$getWeights()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stcp-getLambdas"></a>}}
\if{latex}{\out{\hypertarget{method-Stcp-getLambdas}{}}}
\subsection{Method \code{getLambdas()}}{
Return lambda parameters of mixture of e-values / e-detectors.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stcp$getLambdas()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stcp-getLogValue"></a>}}
\if{latex}{\out{\hypertarget{method-Stcp-getLogValue}{}}}
\subsection{Method \code{getLogValue()}}{
Return the log value of mixture of e-values / e-detectors.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stcp$getLogValue()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stcp-getThreshold"></a>}}
\if{latex}{\out{\hypertarget{method-Stcp-getThreshold}{}}}
\subsection{Method \code{getThreshold()}}{
Return the threshold of the sequential test / change detection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stcp$getThreshold()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stcp-isStopped"></a>}}
\if{latex}{\out{\hypertarget{method-Stcp-isStopped}{}}}
\subsection{Method \code{isStopped()}}{
Return TRUE if the sequential test / change detection was stopped by crossing the threshold.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stcp$isStopped()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stcp-getTime"></a>}}
\if{latex}{\out{\hypertarget{method-Stcp-getTime}{}}}
\subsection{Method \code{getTime()}}{
Return the number of observations having been passed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stcp$getTime()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stcp-getStoppedTime"></a>}}
\if{latex}{\out{\hypertarget{method-Stcp-getStoppedTime}{}}}
\subsection{Method \code{getStoppedTime()}}{
Return the stopped time. If it has been never stopped, return zero.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stcp$getStoppedTime()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stcp-reset"></a>}}
\if{latex}{\out{\hypertarget{method-Stcp-reset}{}}}
\subsection{Method \code{reset()}}{
Reset the stcp object to the initial setup.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stcp$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stcp-updateLogValues"></a>}}
\if{latex}{\out{\hypertarget{method-Stcp-updateLogValues}{}}}
\subsection{Method \code{updateLogValues()}}{
Update the log value and related fields by passing a vector of observations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stcp$updateLogValues(xs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xs}}{A numeric vector of observations.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stcp-updateLogValuesUntilStop"></a>}}
\if{latex}{\out{\hypertarget{method-Stcp-updateLogValuesUntilStop}{}}}
\subsection{Method \code{updateLogValuesUntilStop()}}{
Update the log value and related fields until the log value is crossing the boundary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stcp$updateLogValuesUntilStop(xs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xs}}{A numeric vector of observations.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stcp-updateAndReturnHistories"></a>}}
\if{latex}{\out{\hypertarget{method-Stcp-updateAndReturnHistories}{}}}
\subsection{Method \code{updateAndReturnHistories()}}{
Update the log value and related fields then return updated log values by passing a vector of observations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stcp$updateAndReturnHistories(xs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xs}}{A numeric vector of observations.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stcp-updateLogValuesByAvgs"></a>}}
\if{latex}{\out{\hypertarget{method-Stcp-updateLogValuesByAvgs}{}}}
\subsection{Method \code{updateLogValuesByAvgs()}}{
Update the log value and related fields by passing
a vector of averages and number of corresponding samples.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stcp$updateLogValuesByAvgs(x_bars, ns)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x_bars}}{A numeric vector of averages.}

\item{\code{ns}}{A numeric vector of sample sizes.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stcp-updateLogValuesUntilStopByAvgs"></a>}}
\if{latex}{\out{\hypertarget{method-Stcp-updateLogValuesUntilStopByAvgs}{}}}
\subsection{Method \code{updateLogValuesUntilStopByAvgs()}}{
Update the log value and related fields by passing
a vector of averages and number of corresponding samples
until the log value is crossing the boundary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stcp$updateLogValuesUntilStopByAvgs(x_bars, ns)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x_bars}}{A numeric vector of averages.}

\item{\code{ns}}{A numeric vector of sample sizes.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Stcp-updateAndReturnHistoriesByAvgs"></a>}}
\if{latex}{\out{\hypertarget{method-Stcp-updateAndReturnHistoriesByAvgs}{}}}
\subsection{Method \code{updateAndReturnHistoriesByAvgs()}}{
Update the log value and related fields then return updated log values
a vector of averages and number of corresponding samples.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Stcp$updateAndReturnHistoriesByAvgs(x_bars, ns)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x_bars}}{A numeric vector of averages.}

\item{\code{ns}}{A numeric vector of sample sizes.}
}
\if{html}{\out{</div>}}
}
}
}
