% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_t_test.R
\name{expr_t_robust}
\alias{expr_t_robust}
\title{Expression containing results from a robust \emph{t}-test}
\usage{
expr_t_robust(
  data,
  x,
  y,
  subject.id = NULL,
  paired = FALSE,
  k = 2L,
  conf.level = 0.95,
  tr = 0.1,
  nboot = 100,
  output = "expression",
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{subject.id}{In case of repeated measures design (\code{paired = TRUE},
i.e.), this argument specifies the subject or repeated measures id. Note
that if this argument is \code{NULL} (which is the default), the function
assumes that the data has already been sorted by such an id by the user and
creates an internal identifier. So if your data is \strong{not} sorted and you
leave this argument unspecified, the results can be inaccurate.}

\item{paired}{Logical that decides whether the experimental design is
repeated measures/within-subjects or between-subjects. The default is
\code{FALSE}.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} confidence/credible intervals (\code{0.95}).}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. If you
get error stating "Standard error cannot be computed because of Winsorized
variance of 0 (e.g., due to ties). Try to decrease the trimming level.",
try to play around with the value of \code{tr}, which is by default set to
\code{0.1}. Lowering the value might help.}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{output}{If \code{"expression"}, will return expression with statistical
details, while \code{"dataframe"} will return a dataframe containing the
results.}

\item{...}{Additional arguments (currently ignored).}
}
\description{
Expression containing results from a robust \emph{t}-test
}
\examples{
# for reproducibility
set.seed(123)
library(statsExpressions)

# between-subjects design -----------------------------------------------

# with defaults
expr_t_robust(
  data = sleep,
  x = group,
  y = extra
)

# within-subjects design -----------------------------------------------
expr_t_robust(
  data = dplyr::filter(bugs_long, condition \%in\% c("LDLF", "LDHF")),
  x = condition,
  y = desire,
  paired = TRUE,
  subject.id = subject
)
}
\references{
For more details, see-
\url{https://indrajeetpatil.github.io/statsExpressions/articles/stats_details.html}
}
