% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_effsize_ci.R
\name{yuend_ci}
\alias{yuend_ci}
\title{Paired samples robust \emph{t}-tests with confidence
interval for effect size.}
\usage{
yuend_ci(
  data,
  x,
  y,
  tr = 0.1,
  nboot = 100,
  conf.level = 0.95,
  conf.type = "norm",
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{The grouping variable from the dataframe \code{data}.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. If you
get error stating "Standard error cannot be computed because of Winsorized
variance of 0 (e.g., due to ties). Try to decrease the trimming level.",
try to play around with the value of \code{tr}, which is by default set to
\code{0.1}. Lowering the value might help.}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{conf.level}{Scalar between 0 and 1. If unspecified, the defaults return
\verb{95\%} lower and upper confidence intervals (\code{0.95}).}

\item{conf.type}{A vector of character strings representing the type of
intervals required. The value should be any subset of the values \code{"norm"},
\code{"basic"}, \code{"perc"}, \code{"bca"}. For more, see \code{?boot::boot.ci}.}

\item{...}{Currently ignored.}
}
\description{
Custom function to get confidence intervals for effect size
measure for paired samples robust t-tests.
}
\examples{

# for reproducibility
set.seed(123)
\donttest{
statsExpressions:::yuend_ci(
  data = dplyr::filter(
    .data = statsExpressions::iris_long,
    condition \%in\% c("Sepal.Length", "Petal.Length")
  ),
  x = condition,
  y = value,
  nboot = 50,
  tr = 0.2
)
}
}
\keyword{internal}
