% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quote_cloud.R
\name{quote_cloud}
\alias{quote_cloud}
\title{Function to generate word cloud based upon quote database}
\usage{
quote_cloud(search = ".*", max.words = 80, colors = NA, ...)
}
\arguments{
\item{search}{A character string; used to search the database. Regular
expression characters are allowed. Default is to search all quotes.}

\item{max.words}{Logical; designate maximum number of words to be plotted.}

\item{colors}{A character vector pertaining to the colors to be used to designate
word frequency. The default is 5 levels, from light to dark green.}

\item{...}{additional arguments passed to \code{\link{search_quotes}} and
\code{\link{wordcloud}}}
}
\value{
A wordcloud is plotted.
}
\description{
This function takes a search pattern (can use regular expressions) and generates
a word cloud based upon that filter.
}
\examples{
quote_cloud()
quote_cloud(search = "graph")
quote_cloud(max.words = 10)
}
\seealso{
\code{\link{statquote}}, \code{\link{quote_topics}}, \code{\link{quotes}},
  \code{\link{search_quotes}}. \code{\link{wordcloud}}
}

