% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{test.spear}
\alias{test.spear}
\title{Hypothesis test for a Spearman correlation}
\usage{
test.spear(cor, h, n)
}
\arguments{
\item{cor}{estimated correlation}

\item{h}{null hypothesis value of correlation}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimate of correlation
\item t or z - t test statistic (for h = 0) or z test statistic
\item p - two-sided p-value
}
}
\description{
Computes a t test for a test of the null hypothesis that a population
Spearman correlation is equal to 0, or a z test using a Fisher transformation
for a test of the null hypothesis that a Spearman correlation is equal to
some specified nonzero value. The hypothesis testing results should be
accompanied with a confidence interval for the population Spearman
correlation value (see \link[statpsych]{ci.spear}).
}
\examples{
test.spear(.471, .2, 100)

# Should return:
# Estimate        z           p
#     0.471 3.009628 0.00261568


test.spear(.342, 0, 100)

# Should return:
#  Estimate        t df            p
#     0.342 3.602881 98 0.0004965008


}
