% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.pairs.mult}
\alias{ci.pairs.mult}
\title{Confidence intervals for pairwise proportion differences of a
multinomial variable}
\usage{
ci.pairs.mult(alpha, f)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f}{vector of multinomial frequency counts}
}
\value{
Returns a matrix with the number of rows equal to the number
of pairwise comparisons. The columns are:
\itemize{
\item Estimate - adjusted estimate of proportion difference
\item SE - adjusted standard error
\item LL - lower limit of the adjusted Wald confidence interval
\item UL - upper limit of the adjusted Wald confidence interval
}
}
\description{
Computes adjusted Wald confidence intervals for pairwise proportion
differences of a multinomial variable in a single sample. These adjusted
Wald confidence intervals use the same method that is used to compare the
two proportions in a paired-samples design.
}
\examples{
f <- c(125, 82, 92)
ci.pairs.mult(.05, f)

# Should return:
#        Estimate         SE          LL         UL
# 1 2  0.14285714 0.04731825  0.05011508 0.23559920
# 1 3  0.10963455 0.04875715  0.01407230 0.20519680
# 2 3 -0.03322259 0.04403313 -0.11952594 0.05308076


}
\references{
\insertRef{Bonett2012}{statpsych}
}
