% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.median2}
\alias{ci.median2}
\title{Confidence interval for a 2-group median difference}
\usage{
ci.median2(alpha, y1, y2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y1}{vector of scores for group 1}

\item{y2}{vector of scores for group 2}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Median1 - estimated median for group 1
\item Median2 - estimated median for group 2
\item Median1-Median2 - estimated difference of medians
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a distribution-free confidence interval for a difference of population
medians in a 2-group design.
}
\examples{
y1 <- c(32, 39, 26, 35, 43, 27, 40, 37, 34, 29)
y2 <- c(36, 44, 47, 42, 49, 39, 46, 31, 33, 48)
ci.median2(.05, y1, y2)

# Should return:
# Median1 Median2 Median1-Median2       SE        LL          UL
#    34.5      43            -8.5 4.316291 -16.95977 -0.04022524


}
\references{
\insertRef{Bonett2002}{statpsych}
}
