% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.2x2.mean.mixed}
\alias{ci.2x2.mean.mixed}
\title{Computes tests and confidence intervals of effects in a 2x2 mixed design
for means}
\usage{
ci.2x2.mean.mixed(alpha, y11, y12, y21, y22)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{y11}{vector of scores at level 1 of A and level 1 of B}

\item{y12}{vector of scores at level 1 of A and level 2 of B}

\item{y21}{vector of scores at level 2 of A and level 1 of B}

\item{y22}{vector of scores at level 2 of A and level 2 of B}
}
\value{
Returns a 7-row matrix (one row per effect). The columns are:
\itemize{
\item Estimate - estimate of effect
\item SE - standard error
\item t - t test statistic
\item df - degrees of freedom
\item p - two-sided p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes confidence intervals and tests for the AB interaction effect,
main effect of A, main effect of B, simple main effects of A, and simple main
effects of B in a 2x2 mixed factorial design with a quantitative response
variable where Factor A is a within-subjects factor, and Factor B is a
between-subjects factor. A Satterthwaite adjustment to the degrees of
freedom is used and equality of population variances is not assumed.
}
\examples{
y11 <- c(18, 19, 20, 17, 20, 16)
y12 <- c(19, 18, 19, 20, 17, 16)
y21 <- c(19, 16, 16, 14, 16, 18)
y22 <- c(16, 10, 12,  9, 13, 15)
ci.2x2.mean.mixed(.05, y11, y12, y21, y22)

# Should return:
#            Estimate        SE         t       df            p         LL        UL
# AB:      -3.8333333 0.9803627 -3.910117 8.346534 0.0041247610 -6.0778198 -1.588847
# A:        2.0833333 0.4901814  4.250128 8.346534 0.0025414549  0.9610901  3.205577
# B:        3.7500000 1.0226599  3.666908 7.601289 0.0069250119  1.3700362  6.129964
# A at b1:  0.1666667 0.8333333  0.200000 5.000000 0.8493605140 -1.9754849  2.308818
# A at b2:  4.0000000 0.5163978  7.745967 5.000000 0.0005732451  2.6725572  5.327443
# B at a1:  1.8333333 0.9803627  1.870056 9.943850 0.0911668588 -0.3527241  4.019391
# B at a2:  5.6666667 1.2692955  4.464419 7.666363 0.0023323966  2.7173445  8.615989


}
