% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{size.ci.indirect}
\alias{size.ci.indirect}
\title{Sample size for an indirect effect confidence interval}
\usage{
size.ci.indirect(alpha, cor1, cor2, w)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{cor1}{planning value of correlation between the independent and mediator variables}

\item{cor2}{planning value of correlation between the mediator and response variables}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size
}
\description{
Computes the approximate sample size required to estimate a standardized
indirect effect in a simple mediation model. The direct effect of the
independent (exogenous) variable on the response variable, controlling for
the mediator variable, is assumed to be negligible.
}
\examples{
size.ci.indirect(.05, .4, .5, .2)

# Should return:
# Sample size
#         106
 

}
