% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{ci.mean.ps}
\alias{ci.mean.ps}
\title{Confidence interval for a paired-samples mean difference}
\usage{
ci.mean.ps(alpha, m1, m2, sd1, sd2, cor, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{estimated mean for measurement 1}

\item{m2}{estimated mean for measurement 2}

\item{sd1}{estimated standard deviation for measurement 1}

\item{sd2}{estimated standard deviation for measurement 2}

\item{cor}{estimated correlation between measurements}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated mean difference
\item SE - standard error
\item t - t test statistic
\item df - degrees of freedom
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a confidence interval for a population paired-samples mean
difference using the estimated means, estimated standard deviations,
estimated correlation, and sample size. Use the t.test function for
raw data input.
}
\examples{
ci.mean.ps(.05, 58.2, 51.4, 7.43, 8.92, .537, 30)

# Should return:
#      Estimate       SE        t df            p       LL       UL
# [1,]      6.8 1.455922 4.670578 29  6.33208e-05 3.822304 9.777696


}
