% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{size.test.slope}
\alias{size.test.slope}
\title{Sample size for a test of a slope}
\usage{
size.test.slope(alpha, pow, evar, x, slope, h)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{evar}{planning value of within group (error) variance}

\item{x}{vector of x values of the quantitative factor}

\item{slope}{planning value of slope}

\item{h}{hypothesized value of slope}
}
\value{
Returns the required total sample size
}
\description{
Computes the total sample size required to test a population slope with
desired power in a between-subjects design with a quantitative factor.
In an experimental design, the total sample size would be allocated to the
levels of the quantitative factor and it might be necessary to use a larger
total sample size to achieve equal sample sizes. Set the error variance
planning value to the largest value within a plausible range for a
conservatively large sample size.
}
\examples{
x <- c(2, 5, 8)
size.test.slope(.05, .9, 31.1, x, .75, 0)

# Should return:
#      Sample size
# [1,]         100
 

}
