% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{sp_load_table}
\alias{sp_load_table}
\title{Load a statnipokladna table from a CSV file}
\usage{
sp_load_table(path, ico = NULL)
}
\arguments{
\item{path}{path to a CSV file, as output by \code{sp_get_table_file()}.}

\item{ico}{Organisation ID to filter by, if supplied.}
}
\value{
a \link[tibble:tibble-package]{tibble}. See help for \code{sp_get_table()} for a key to the columns.
}
\description{
This is normally called inside \code{sp_get_table()} but can be used separately if
finer-grained control of intermediate outputs is needed, e.g. in a {targets} workflow.
}
\examples{
\dontrun{
ds <- sp_get_dataset("rozv", 2018, 12)
tf <- sp_get_table_file("balance-sheet", ds)
sp_load_table(tf)
}
}
\seealso{
Other Detailed workflow: 
\code{\link{sp_get_codelist_file}()},
\code{\link{sp_get_dataset_url}()},
\code{\link{sp_get_table_file}()},
\code{\link{sp_load_codelist}()}
}
\concept{Detailed workflow}
