% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createStability.R
\name{report.stability}
\alias{report.stability}
\title{Report method for class stability}
\usage{
\method{report}{stability}(x, ..., outfile = NULL)
}
\arguments{
\item{x}{An object of class stability.}

\item{...}{Not used.}

\item{outfile}{A character string, the name and location of the output .pdf
and .tex file for the report. If \code{NULL}, a report with a default name
will be created in the current working directory.}
}
\value{
A pdf and tex report.
}
\description{
A pdf report will be created containing a summary of an object of class
stability. Simultaneously the same report will be created as a tex file.
}
\examples{
## Compute three stability measures for TDMaize.
geStab <- gxeStability(TD = TDMaize, trait = "yld")
\donttest{
## Create a .pdf report summarizing the stability measures.
report(geStab, outfile = tempfile(fileext = ".pdf"))
}

}
\seealso{
Other stability: 
\code{\link{gxeStability}()},
\code{\link{plot.stability}()}
}
\concept{stability}
