% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elapsed_dates.R
\name{elapsed}
\alias{elapsed}
\alias{quarterly,}
\alias{monthly}
\alias{as.quarterly}
\alias{is.quarterly}
\alias{as.monthly}
\alias{is.monthly}
\title{Elapsed dates (monthly, quarterly)}
\usage{
as.quarterly(x)

is.quarterly(x)

as.monthly(x)

is.monthly(x)
}
\arguments{
\item{x}{a vector}
}
\description{
Elapsed dates (monthly, quarterly)
}
\details{
Monthly and quarterly dates are stored as integers, representing the number of elapsed calendar periods since 01/01/1970.  As \code{yearmonth} and \code{yearqtr} the package \code{zoo}, these dates are printed in a way that fits their frequency  (\code{YYY}q\code{q}, \code{YYY}m\code{MM}). The only difference is that, \code{monthly}, and \code{quarterly} are integers, which removes issues due to floating points (particularly important when merging). This also allows to use arithmetic on perios, ie \code{date} + 1 adds one period rather than one day.

Methods to convert from and to Dates or POSIXlt are provided. In particular, you may use lubridate \code{\link{week}} \code{\link{month}} and \code{\link{year}} to extract information from elapsed dates.
}
\examples{
library(lubridate)
library(dplyr)
date <- mdy(c("04/03/1992", "01/04/1992", "03/15/1992"))  
datem <- as.monthly(date)
is.monthly(datem)
as.quarterly(date)
as.character(datem)
datem + 1
df <- data_frame(datem)
# filter(df, month(datem) == 1)
lag(c(1, 2, 3), n = 1, along_with = datem)
seq(datem[1], datem[2])
as.Date(datem)
as.POSIXlt(datem)
as.POSIXct(datem)
week(datem)
}
