% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{ghoshdastidar.test}
\alias{ghoshdastidar.test}
\title{Ghoshdastidar hypothesis testing for large random graphs.}
\usage{
ghoshdastidar.test(G1, G2, maxBoot = 300, two.sample = FALSE)
}
\arguments{
\item{G1}{the first list of undirected graphs to be compared. Must be a list
of matrices or igraph objects.}

\item{G2}{the second list of undirected graphs to be compared. Must be a list
of matrices or igraph objects.}

\item{maxBoot}{integer indicating the number of bootstrap resamples (default
is 300).}

\item{two.sample}{logical. If TRUE the sets contain only one graph each. If
FALSE the sets contain more than one graph each (default is FALSE).}
}
\value{
A list containing:
\item{T}{the value of the test.}
\item{p.value}{the p-value of the test (only returned when the parameter
'two.sample' is FALSE).}
}
\description{
Given two lists of graphs generated by the inhomogeneous random graph model,
\code{ghoshdastidar.test} tests if they were generated by the same parameters.
}
\examples{
\dontrun{
set.seed(42)

## test for sets with more than one graph each under H0
G1 <- G2 <- list()
for(i in 1:10){
  G1[[i]] <- as.matrix(igraph::get.adjacency(igraph::sample_gnp(50,0.6)))
  G2[[i]] <- as.matrix(igraph::get.adjacency(igraph::sample_gnp(50,0.6)))
}
D1 <- ghoshdastidar.test(G1, G2)
D1

## test for sets with more than one graph each under H1
G1 <- G2 <- list()
for(i in 1:10){
  G1[[i]] <- as.matrix(igraph::get.adjacency(igraph::sample_gnp(50,0.6)))
  G2[[i]] <- as.matrix(igraph::get.adjacency(igraph::sample_gnp(50,0.7)))
}
D2 <- ghoshdastidar.test(G1, G2)
D2

## test for sets with only one graph each under H0
G1 <- G2 <- list()
G1[[1]] <- igraph::sample_gnp(300, 0.6)
G2[[1]] <- igraph::sample_gnp(300, 0.6)
D3 <- ghoshdastidar.test(G1, G2, two.sample= TRUE)
D3

## test for sets with only one graph each under H1
G1 <- G2 <- list()
G1[[1]] <- igraph::sample_gnp(300, 0.6)
G2[[1]] <- igraph::sample_gnp(300, 0.7)
D4 <- ghoshdastidar.test(G1, G2, two.sample= TRUE)
D4
}

}
\references{
Ghoshdastidar, Debarghya, et al. "Two-sample tests for large random graphs
using network statistics". arXiv preprint arXiv:1705.06168 (2017).

Ghoshdastidar, Debarghya, et al. "Two-sample hypothesis testing for
inhomogeneous random graphs". arXiv preprint, arXiv:1707.00833 (2017).
}
