% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multistar_as_flat_table.R
\name{multistar_as_flat_table}
\alias{multistar_as_flat_table}
\alias{multistar_as_flat_table.multistar}
\title{Export a multistar as a flat table}
\usage{
multistar_as_flat_table(ms, name = NULL)

\method{multistar_as_flat_table}{multistar}(ms, name = NULL)
}
\arguments{
\item{ms}{A \code{multistar} object.}

\item{name}{A string, name of the fact.}
}
\value{
A \code{tibble}.
}
\description{
We can obtain a flat table, implemented using a \code{tibble}, from a \code{multistar}
(which can be the result of a query). If it only has one fact table, it is
not necessary to provide its name.
}
\examples{
library(tidyr)

ft <- ms_mrs \%>\%
  multistar_as_flat_table(name = "mrs_age")

ms <- dimensional_query(ms_mrs) \%>\%
  select_dimension(name = "where",
                  attributes = c("city", "state")) \%>\%
  select_dimension(name = "when",
                  attributes = c("year")) \%>\%
  select_fact(
    name = "mrs_age",
    measures = c("deaths")
  ) \%>\%
  select_fact(name = "mrs_cause",
             measures = c("pneumonia_and_influenza_deaths", "other_deaths")) \%>\%
  filter_dimension(name = "when", week <= "03") \%>\%
  filter_dimension(name = "where", city == "Boston") \%>\%
  run_query()

ft <- ms \%>\%
  multistar_as_flat_table()

}
\seealso{


Other results export functions: 
\code{\link{constellation_as_multistar}()},
\code{\link{constellation_as_tibble_list}()},
\code{\link{star_schema_as_flat_table}()},
\code{\link{star_schema_as_multistar}()},
\code{\link{star_schema_as_tibble_list}()}
}
\concept{results export functions}
