% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record_update_set_match_records.R
\name{match_records}
\alias{match_records}
\alias{match_records.record_update_set}
\title{Make a dimension record equal to another}
\usage{
match_records(updates, dimension, old, new)

\method{match_records}{record_update_set}(updates, dimension, old, new)
}
\arguments{
\item{updates}{A \code{record_update_set} object.}

\item{dimension}{A \code{dimension_table} object, dimension to update.}

\item{old}{A number, primary key of the record to update.}

\item{new}{A number, primary key of the record from which the values are
taken.}
}
\value{
A \code{record_update_set} object.
}
\description{
For a dimension, given the primary key of two records, it adds an update to
the set of updates that modifies the combination of values of the rest of
attributes of the first record so that they become the same as those of the
second.
}
\details{
Primary keys are only used to get the combination of values easily. The
update is defined exclusively from the rest of values.

It is especially useful when it is detected that two records should be only
one: Two have been generated due to some data error.
}
\examples{

library(tidyr)

dim_names <- st_mrs_age \%>\%
    get_dimension_names()

where <- st_mrs_age \%>\%
  get_dimension("where")

# head(where, 2)

updates <- record_update_set() \%>\%
  match_records(dimension = where,
                old = 1,
                new = 2)

}
\seealso{


Other data cleaning functions: 
\code{\link{get_conformed_dimension_names}()},
\code{\link{get_conformed_dimension}()},
\code{\link{get_dimension_names}()},
\code{\link{get_dimension}()},
\code{\link{modify_conformed_dimension_records}()},
\code{\link{modify_dimension_records}()},
\code{\link{record_update_set}()},
\code{\link{update_record}()},
\code{\link{update_selection_general}()},
\code{\link{update_selection}()}
}
\concept{data cleaning functions}
