% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_to_nearest.R
\name{dist_to_nearest}
\alias{dist_to_nearest}
\title{Calculate raster of distances to nearest feature}
\usage{
dist_to_nearest(x, v, progress = TRUE)
}
\arguments{
\item{x}{A \code{stars} layer, used as a "grid" for distance calculations}

\item{v}{An \code{sf}, \code{sfc} or \code{sfg} object}

\item{progress}{Display progress bar? The default is \code{TRUE}}
}
\value{
A \code{stars} raster with distances to nearest feature
}
\description{
Given a \code{stars} raster and an \code{sf} vector layer, returns a new raster with the distances of each cell centroid to the nearest feature in the vector layer.
}
\examples{
# Sample 'sf' layer
x = st_point(c(0,0))
y = st_point(c(1,1))
x = st_sfc(x, y)
x = st_sf(x)
x = st_buffer(x, 0.5)

# Make grid
r = make_grid(x, res = 0.1, buffer = 0.5)
d = dist_to_nearest(r, x, progress = FALSE)

# Plot
plot(d, breaks = "equal", axes = TRUE, reset = FALSE)
plot(st_geometry(x), add = TRUE, pch = 4, cex = 3)
}
