% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_files.R
\name{rename_files}
\alias{rename_files}
\title{Rename multiple files}
\usage{
rename_files(input_directory = NULL, new_names)
}
\arguments{
\item{input_directory}{the path of the input PDF files.
The default is set to NULL. IF NULL, it  prompt the user to
select the folder interactively.}

\item{new_names}{a vector of names for the output files.}
}
\value{
this function writes renamed files back to directory
}
\description{
Rename multiple files in a directory and
write renamed files back to directory
}
\examples{
\dontrun{
#if the directory contains 3 PDF files
rename_files(new_names = paste("file",1:3))
}
\dontshow{
dir <- tempdir()
require(lattice)
for(i in 1:3) {
pdf(file.path(dir, paste("plot", i, ".pdf", sep = "")))
print(xyplot(iris[,1] ~ iris[,i], data = iris))
dev.off()
}
n <- length(Sys.glob(file.path(dir,"*.pdf")))
rename_files(input_directory = dir, new_names = paste("file",1:n))
}
}
\references{
\url{https://www.pdflabs.com/tools/pdftk-the-pdf-toolkit/}
}
\author{
Priyanga Dilini Talagala
}
