% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardized-class.R
\name{predict.standardized}
\alias{predict.standardized}
\title{Place new data into an already existing standardized space.}
\usage{
\method{predict}{standardized}(object, newdata, response = FALSE,
  fixed = TRUE, random = TRUE, na.action = "na.pass", ...)
}
\arguments{
\item{object}{An object of class \code{standardized}.}

\item{newdata}{Data to be placed into the same standardized space as the
data in the call to \code{\link{standardize}} which produced the
\code{\link[=standardized-class]{standardized}} object.}

\item{response}{A logical (default \code{FALSE}) indicating whether
\code{newdata} contains the response variable.}

\item{fixed}{A logical (default \code{TRUE}) indicating whether
\code{newdata} contains variables pertaining to the fixed effects.}

\item{random}{A logical (default \code{TRUE}) indicating whether
\code{newdata} contains variables pertaining to the random effects.}

\item{na.action}{See \code{\link[stats]{model.frame}}.}

\item{...}{Ignored with a warning.}
}
\value{
A data.frame with the \code{newdata} standardized using the
  \code{pred} element of the \code{\link[=standardized-class]{standardized}}
  object.
}
\description{
To put new data into the same standardized space as the data in the
\code{\link[=standardized-class]{standardized}} object, 
\code{predict} can be used with the \code{standardized} object as the first
argument.  The \code{predict} method also allows logicals \code{response},
\code{fixed}, and \code{random} to be used to specify which elements of the
original data frame are present in \code{newdata}.  A regression model
fit with the \code{formula} and \code{data} elements of a
\code{\link[=standardized-class]{standardized}} object cannot be used to
directly predict the response variable for new data.  The new data must
first be placed into the standardized space.
}
\section{Note}{
 You may see a warning "contrasts dropped from factor <x>" for
  each factor when predicting new data with a fitted model object, but this
  warning can be ignored (the actual predictions will still be correct).
}
\examples{
\dontrun{
train <- subset(mydata, train)
test <- subset(mydata, !train)
train.s <- standardize(y ~ x1 + f1 + (1 | g1), train)
mod <- lmer(train.s$formula, train.s$data)
test.s <- predict(train.s, test, response = TRUE)
preds <- predict(mod, newdata = test.s)  # can ignore warning about dropped contrasts
res <- test.s$y - preds
}

}

