% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stamp.map.r
\name{stamp.map}
\alias{stamp.map}
\title{Mapping (plotting) functionality for \code{stamp} output}
\usage{
stamp.map(stmp, by = "LEV1", ...)
}
\arguments{
\item{stmp}{output from the \code{stamp} function, i.e., a (\code{SpatialPolygonsDataFrame}).}

\item{by}{tells the function which attribute to visualize, one of \code{"LEV1"},
\code{"LEV2"}, \code{"LEV3"}, \code{"LEV4"}, or \code{"GROUP"}}

\item{...}{additional parameters to be passed to the plot function}
}
\value{
\code{stamp.map} returns a map of the \code{stamp} output using the \code{spplot} functionality. 
  It implements a pre-defined coloring scheme.
}
\description{
This function maps STAMP output for visual assessment of STAMP events and groupings.
 Choice of which aspect of the stamp output to be visualized is controlled by passing
 the column name to the \code{stamp.map} function.
}
\details{
The \code{stamp.map} function can be used to visualize any of the stamp event designation levels
 (e.g., \code{"LEV1"}, \code{"LEV2"}, \code{"LEV3"}, \code{"LEV4"}, or the STAMP groupings
 (based off of parameter \code{dc} in the \code{stamp} function).
}
\seealso{
stamp
data("fire1")
data("fire2")
fire1$ID <- 1:nrow(fire1) 
fire2$ID <- (max(fire1$ID)+1):(max(fire1$ID) + nrow(fire2))
ch <- stamp(fire1, fire2, dc=1, direction=FALSE, distance=FALSE)
stamp.map(ch, "LEV1") 
stamp.map(ch, "LEV2") 
stamp.map(ch, "LEV3") 
stamp.map(ch, "LEV4")
}
\keyword{plot}
\keyword{stamp}

