% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-util-functions.R
\name{generate_linear_dataset}
\alias{generate_linear_dataset}
\title{generate a random binary dataset for classification}
\usage{
generate_linear_dataset(n = 2, N = 10000, eps = 1.2,
  gamma = runif(1, min = -n, max = n), alpha = runif(n, min = -n, max =
  n))
}
\arguments{
\item{n}{number of variables}

\item{N}{number of observations}

\item{eps}{noise}

\item{gamma}{numeric}

\item{alpha}{numeric vector of length \code{n}}
}
\value{
A data.frame with \code{n} independent random variables and
one class variable \code{C} computed as
\code{sign(sum(x * alpha) + runif(1, -eps, eps) + gamma)}
}
\description{
Randomly generate a simple classification problem
}
\examples{
DD <- generate_linear_dataset(n = 5, 1000)
}
