% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_candidates.R
\name{add_candidates}
\alias{add_candidates}
\title{Add model definitions to a data stack}
\usage{
add_candidates(
  data_stack,
  candidates,
  name = deparse(substitute(candidates)),
  ...
)
}
\arguments{
\item{data_stack}{A \code{data_stack} object.}

\item{candidates}{A model definition: either a \code{tune_results}
or \code{resample_results} object outputted from
\code{\link[tune:tune_grid]{tune::tune_grid()}}, \code{\link[tune:tune_bayes]{tune::tune_bayes()}}, or \code{\link[tune:fit_resamples]{tune::fit_resamples()}}.
These results must have been fitted with the \code{control} settings
\verb{save_pred = TRUE, save_workflow = TRUE}—see the \code{\link[=control_stack_grid]{control_stack_grid()}},
\code{\link[=control_stack_bayes]{control_stack_bayes()}}, and \code{\link[=control_stack_resamples]{control_stack_resamples()}}
documentation for helper functions.}

\item{name}{The label for the model definition---defaults to the name
of the \code{candidates} object.}

\item{...}{Additional arguments. Currently ignored.}
}
\value{
A \code{data_stack} object--see \code{\link[=stacks]{stacks()}} for more details!
}
\description{
\code{add_candidates()} collates the assessment set predictions
and additional attributes from the supplied model definition
(i.e. set of "candidates") to a data stack.

Behind the scenes, data stack objects are just \link[tibble:tbl_df-class]{tibble::tbl_df}s,
where the first column gives the true response values,
and the remaining columns give the assessment set predictions
for each candidate. In the regression setting, there's only
one column per ensemble member. In classification settings,
there are as many columns per candidate ensemble member
as there are levels of the outcome variable.

To initialize a data stack, use the \code{stacks()} function.
Model definitions are appended to a data stack iteratively
using several calls to \code{add_candidates()}. Data stacks are
evaluated using the \code{\link[=blend_predictions]{blend_predictions()}} function.
}
\section{Example Data}{


This package provides some resampling objects and datasets for use in examples
and vignettes derived from a study on 1212 red-eyed tree frog embryos!

Red-eyed tree frog (RETF) embryos can hatch earlier than their normal
7ish days if they detect potential predator threat. Researchers wanted
to determine how, and when, these tree frog embryos were able to detect
stimulus from their environment. To do so, they subjected the embryos
at varying developmental stages to "predator stimulus" by jiggling
the embryos with a blunt probe. Beforehand, though some of the embryos
were treated with gentamicin, a compound that knocks out their lateral
line (a sensory organ.) Researcher Julie Jung and her crew found that
these factors inform whether an embryo hatches prematurely or not!

Note that the data included with the stacks package is not necessarily
a representative or unbiased subset of the complete dataset, and is
only for demonstrative purposes.

\code{reg_folds} and \code{class_folds} are \code{rset} cross-fold validation objects
from \code{rsample}, splitting the training data into for the regression
and classification model objects, respectively. \code{tree_frogs_reg_test} and
\code{tree_frogs_class_test} are the analogous testing sets.

\code{reg_res_lr}, \code{reg_res_svm}, and \code{reg_res_sp} contain regression tuning results
for a linear regression, support vector machine, and spline model, respectively,
fitting \code{latency} (i.e. how long the embryos took to hatch in response
to the jiggle) in the \code{tree_frogs} data, using most all of the other
variables as predictors. Note that the data underlying these models is
filtered to include data only from embryos that hatched in response to
the stimulus.

\code{class_res_rf} and \code{class_res_nn} contain multiclass classification tuning
results for a random forest and neural network classification model,
respectively, fitting \code{reflex} (a measure of ear function) in the
data using most all of the other variables as predictors.

\code{log_res_rf} and \code{log_res_nn}, contain binary classification tuning results
for a random forest and neural network classification model, respectively,
fitting \code{hatched} (whether or not the embryos hatched in response
to the stimulus) using most all of the other variables as predictors.

See \code{?example_data} to learn more about these objects, as well as browse
the source code that generated them.
}

\examples{
\dontshow{if (rlang::is_installed("kernlab")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# see the "Example Data" section above for
# clarification on the objects used in these examples!

# put together a data stack using
# tuning results for regression models
reg_st <- 
  stacks() \%>\%
  add_candidates(reg_res_lr) \%>\%
  add_candidates(reg_res_svm) \%>\%
  add_candidates(reg_res_sp)
  
reg_st
  
# do the same with multinomial classification models
class_st <-
  stacks() \%>\%
  add_candidates(class_res_nn) \%>\%
  add_candidates(class_res_rf)
  
class_st
  
# ...or binomial classification models
log_st <-
  stacks() \%>\%
  add_candidates(log_res_nn) \%>\%
  add_candidates(log_res_rf)
  
log_st
  
# use custom names for each model:
log_st2 <-
  stacks() \%>\%
  add_candidates(log_res_nn, name = "neural_network") \%>\%
  add_candidates(log_res_rf, name = "random_forest")
  
log_st2
  
# these objects would likely then be
# passed to blend_predictions():
log_st2 \%>\% blend_predictions()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other core verbs: 
\code{\link{blend_predictions}()},
\code{\link{fit_members}()},
\code{\link{stacks}()}
}
\concept{core verbs}
