% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/pdispl.R
\name{pdispl}
\alias{pdispl}
\title{Discrete Powerlaw Distribution Function}
\usage{
pdispl(q, xmin, alpha, lower.tail = TRUE)
}
\arguments{
\item{q}{Vector of quantiles.}

\item{xmin}{The lower bound of the powerlaw distribution.}

\item{alpha}{The scaling parameter.}

\item{lower.tail}{Logical, whether is returned the cumulative distribution function insted of the complementary cumulative distribution function. By default is set to TRUE.}
}
\description{
Complementary cumulative distribution function for the discrete power law distribution with parameters xmin and alpha.
}
\examples{
x = rdispl(n = 1e4, xmin = 10, alpha = 2.5)
pdispl(x, xmin = 10, alpha = 2.5, lower.tail = TRUE)
}
\keyword{complementary}
\keyword{cumulative}
\keyword{discrete}
\keyword{distribution}
\keyword{function}
\keyword{powerlaw}

