% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correction_functions.R
\name{eem_rem_scat}
\alias{eem_rem_scat}
\title{Remove Raman and Rayleigh scattering in fluorescence data}
\usage{
eem_rem_scat(data, remove_scatter, remove_scatter_width = 10,
  interpolation = FALSE, cores = parallel::detectCores(logical =
  FALSE), verbose = FALSE)
}
\arguments{
\item{data}{object of class eemlist}

\item{remove_scatter}{logical vector. The meanings of the vector are "raman1", "raman2", "rayleigh1" and "rayleigh2" scattering. Set \code{TRUE} if certain scattering should be removed.}

\item{remove_scatter_width}{numeric vector containing width of scattering to remove. If there is only one element in this vector, each this is the width of each removed scattering. If there are 4 values, differnt widths are used ordered by "raman1", "raman2", "rayleigh1" and "rayleigh2".}

\item{interpolation}{logical, optionally states whether interpolation is done right away}

\item{cores}{optional, CPU cores to use for interpolation}

\item{verbose}{logical, provide additional information}
}
\value{
eemlist
}
\description{
Wrapper function to remove several scatterings in one step using \code{\link[eemR]{eem_remove_scattering}}.
}
\examples{
data(eem_list)

remove_scatter <- c(TRUE, TRUE, TRUE, TRUE)

remove_scatter_width = c(15,10,16,12)

eem_rem_scat(eem_list,remove_scatter,remove_scatter_width)
}
