% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absorption_functions.R
\name{absorbance_read}
\alias{absorbance_read}
\title{Reading absorbance data from txt and csv files.}
\usage{
absorbance_read(absorbance_path, order = TRUE, recursive = TRUE,
  dec = NULL, sep = NULL, verbose = FALSE, ...)
}
\arguments{
\item{absorbance_path}{directory containing absorbance data files or path to single file. See details for format of absorbance data.}

\item{order}{logical, data is ordered according to wavelength}

\item{recursive}{read files recursive, include subfolders}

\item{dec}{optional, either you set a decimal separator or the table is tested for . and ,}

\item{sep}{optional, either you set a field separator or it is tried to be determined automatically}

\item{verbose}{logical, provide more information}

\item{...}{additional arguments that are passed on to \code{\link[data.table]{fread}}.}
}
\value{
A data frame containing absorbance data. An attribute "location" contains the filenames where each sample was taken from.
}
\description{
Reading absorbance data from txt and csv files.
}
\details{
If absorbance_path is a directory, contained files that end on "csv" or "txt" are passed on to \code{read.table}. If the path is a file, this file is read. Tables can either contain data from one sample or from several samples in columns. The first column is considered the wavelength column. A multi-sample file must have sample names as column names. All tables are combined to one with one wavelength column and one column for each sample containing the absorbance data.
    Column and decimal separators are guessed from the supplied data. In some cases, this can lead to strange results. Plaese set `sep` and `dec` manually if you encounter any problems.
}
\examples{
absorbance_path <- system.file("extdata", "absorbance", package = "staRdom")
absorbance <- absorbance_read(absorbance_path, verbose = TRUE)
}
\seealso{
\code{\link[data.table]{fread}}
}
