% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STVARconstruction.R
\name{filter_estimates}
\alias{filter_estimates}
\title{Filter inappropriate the estimates produced by fitSTVAR}
\usage{
filter_estimates(
  stvar,
  which_largest = 1,
  filter_stab = TRUE,
  calc_std_errors = FALSE
)
}
\arguments{
\item{stvar}{a class 'stvar' object defining a structural STVAR model that is identified by heteroskedasticity
or non-Gaussianity, typically created with \code{fitSSTVAR}.}

\item{which_largest}{an integer at least one specifying the (possibly) appropriate estimate corresponding
to which largest log-likelihood should be returned. E.g., if \code{which_largest=2}, the function will
return among the estimates that it does not deem inappropriate the one that has the second largest log-likelihood.}

\item{filter_stab}{Should estimates close to breaking the usual stability condition be filtered out?}

\item{calc_std_errors}{should approximate standard errors be calculated?}
}
\value{
Returns an S3 object of class \code{'stvar'} defining a smooth transition VAR model. The returned list
 contains the following components (some of which may be \code{NULL} depending on the use case):
   \item{data}{The input time series data.}
   \item{model}{A list describing the model structure.}
   \item{params}{The parameters of the model.}
   \item{std_errors}{Approximate standard errors of the parameters, if calculated.}
   \item{transition_weights}{The transition weights of the model.}
   \item{regime_cmeans}{Conditional means of the regimes, if data is provided.}
   \item{total_cmeans}{Total conditional means of the model, if data is provided.}
   \item{total_ccovs}{Total conditional covariances of the model, if data is provided.}
   \item{uncond_moments}{A list of unconditional moments including regime autocovariances, variances, and means.}
   \item{residuals_raw}{Raw residuals, if data is provided.}
   \item{residuals_std}{Standardized residuals, if data is provided.}
   \item{structural_shocks}{Recovered structural shocks, if applicable.}
   \item{loglik}{Log-likelihood of the model, if data is provided.}
   \item{IC}{The values of the information criteria (AIC, HQIC, BIC) for the model, if data is provided.}
   \item{all_estimates}{The parameter estimates from all estimation rounds, if applicable.}
   \item{all_logliks}{The log-likelihood of the estimates from all estimation rounds, if applicable.}
   \item{which_converged}{Indicators of which estimation rounds converged, if applicable.}
   \item{which_round}{Indicators of which round of optimization each estimate belongs to, if applicable.}
   \item{LS_estimates}{The least squares estimates of the parameters in the form
     \eqn{(\phi_{1,0},...,\phi_{M,0},\varphi_1,...,\varphi_M,\alpha} (intercepts replaced by unconditional means
     if mean parametrization is used), if applicable.}
}
\description{
\code{filter_estimates} filters out inappropriate estimates produced by \code{fitSTVAR}:
  can be used to obtain the (possibly) appropriate estimate with the largest found log-likelihood
  (among possibly appropriate estimates) as well as (possibly) appropriate estimates based on smaller
  log-likelihoods.
}
\details{
The function goes through the estimates produced by \code{fitSTVAR} and checks which estimates are
 deemed inappropriate. That is, estimates that are not likely solutions of interest. Specifically, solutions
 that incorporate a near-singular error term covariance matrix (any eigenvalue less than \eqn{0.002}),
 any modulus of the eigenvalues of the companion form AR matrices larger than $0.9985$ (indicating the
 necessary condition for stationarity is close to break), or transition weights such that they are close to zero
 for almost all \eqn{t} for at least one regime. Then, among the solutions are not deemed inappropriate, it
 returns a STVAR models based on the estimate that has the \code{which_largest} largest log-likelihood.

 The function \code{filter_estimates} is kind of a version of \code{alt_stvar} that only considers estimates
 that are not deemed inappropriate
}
\examples{
\donttest{
 # Fit a two-regime STVAR model with logistic transition weights and Student's t errors,
 # and use two-phase estimation method:
 fit12 <- fitSTVAR(gdpdef, p=1, M=2, weight_function="logistic", weightfun_pars=c(2, 1),
  cond_dist="Student", nrounds=2, ncores=2, seeds=1:2, estim_method="two-phase")
 fit12

 # Filter through inappropriate estimates and obtain the second best appropriate solution:
 fit12_2 <- filter_estimates(fit12, which_largest=2)
 fit12_2 # The same model since the two estimation rounds yielded the same estimate
}
}
\seealso{
\code{\link{fitSTVAR}}, \code{\link{alt_stvar}}
}
