% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sim.counts.R
\name{sim.counts}
\alias{sim.counts}
\title{RNA-seq Count Data Simulation from Negative-Binomial Distribution}
\usage{
sim.counts(arg, mu, disp, logfc, up = 0.5, replace = TRUE)
}
\arguments{
\item{arg}{a list of global parameters to pass into the function, such as total number of genes,
proportion of non-differentially expressed genes and treatment groups. See Details for more information.}

\item{mu}{a vector (or scalar) of mean counts in control group from which to simulate.}

\item{disp}{a vector (or scalar) of dispersion parameter from which to simulate.}

\item{logfc}{a vector (or scalar) of log fold change between treatment group and control group.}

\item{up}{proportion of up-regulated genes among all differentially expressed genes, the default value is \code{0.5}.}

\item{replace}{sample with or without replacement from given parameters. See Details for more information.}
}
\value{
\item{counts}{RNA-seq count data matrix.}

\item{group}{treatment group vector.}

\item{lambda0}{mean counts in control group for each gene.}

\item{phi0}{dispersion parameter for each gene.}

\item{de}{differentially expressed genes indicator: \code{0} for non-differentially expressed genes,
\code{1} for up-regulated genes, \code{-1} for down-regulated genes.}

\item{delta}{log fold change for each gene between treatment group and control group.}
}
\description{
This function simulates count data from Negative-Binomial distribution
for RNA-seq experiments with given mean, dispersion and log fold change.
A count data matrix is generated.
}
\details{
\code{arg = list(nG, pi0, group)} where \code{nG} is the total number of genes, \code{pi0}
is the proportion of non-differentially expressed genes, and \code{group} is the treatment groups.

If the total number of genes is larger than length of \code{mu} or \code{disp},
\code{replace} always equals \code{TRUE}.
}
\examples{
arg <- list(nG = 10000,                      ## total number of genes
            pi0 = 0.8,                       ## proportion of non-differentially expressed genes
            group = rep(c(1, 2), each = 3))  ## treatment groups
mu <- 10                                     ## mean counts in control group for all genes
disp <- 0.1                                  ## dispersion for all genes
logfc <- log(2)                              ## log fold change for up-regulated genes

RNA_simu <- sim.counts(arg, mu, disp, logfc, up = 0.5, replace = TRUE)
RNA_simu$counts                              ## count data matrix
}
\author{
Ran Bi \email{biran@iastate.edu}, Peng Liu \email{pliu@iastate.edu}
}

