% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxtest.R
\name{maxtest}
\alias{maxtest}
\title{Max test for detecting simultaneous signals}
\usage{
maxtest(T1, T2)
}
\arguments{
\item{T1, T2}{paired vectors of test statistics, both must be the same length; must be stochastically larger under the alternative than under the null; must contain only positive values}
}
\value{
\item{p}{p-value}
\item{M}{value of max statistic}
}
\description{
Given two sequences of paired test statistics, tests whether any simultaneous signals exist
}
\examples{
## generate paired test statistics
p <- 10^6; ## total number of pairs
X <- c(rep(0,p-30),rep(1,10),rep(2,10),rep(3,10));
## X=0: no signal in either sequence of tests
## X=1: signal in sequence 1 only
## X=2: signal in sequence 2 only
## X=3: simultaneous signal
set.seed(1);
Z1 <- rnorm(p,0,1); Z1[X==1|X==3] <- rnorm(20,3,1);
Z2 <- rnorm(p,0,1); Z2[X==2|X==3] <- rnorm(20,4,1);
maxtest(abs(Z1),abs(Z2));

}

