% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{generate_data}
\alias{generate_data}
\title{Generate datasets according to the model structure}
\usage{
generate_data(M = 100, N = 61, I = 10, J = 12, K = c(4),
  Z.type = c("symmetric"), Z.contrast = "treatment",
  Z.formula = NULL, sigmax = 1, lambda = 1.5, yT = pi/4, yD = (3
  * pi)/4, priors = "default", ...)
}
\arguments{
\item{M}{(integer) number of simulated datasets}

\item{N}{(integer) length of the Y-trajectories}

\item{I}{(integer) number of individuals}

\item{J}{(integer) number of trials}

\item{K}{(array of integers) list of length Q of the number of levels for each categorical variable}

\item{Z.type}{(array of characters) list of length Q of the methods (symmetric or random) to generate the matrix (see \code{\link{generate_Z}})}

\item{Z.contrast}{(character) type of contrasts (default: treatment) for the model matrix Z (see \code{\link{model.matrix}})}

\item{Z.formula}{(character) a formula of the contrasts for the model matrix Z (see \code{\link{model.matrix}})}

\item{sigmax}{(numeric) fixed value for the model parameter sigmax}

\item{lambda}{(numeric) fixed value for the model parameter lambda}

\item{yT}{(numeric) position in angles of the target}

\item{yD}{(numeric) position in angles of the distractor}

\item{priors}{(list) a list of arguments specifying priors for each parameter involved in the model (see \code{\link{check_prior}}). If \code{priors="default"} then pre-defined vague priors will be used.}

\item{...}{other stan arguments (e.g., 'init', 'algorithm', 'sample_file'. See \code{\link[rstan:sampling]{sampling}})}
}
\value{
a datalist containing simulated data
}
\description{
Generate datasets according to the model structure
}
\details{
The function generates simulated datasets via Stan according to the model structure.
}
\examples{

\dontrun{
## Generate mouse-tracking data for an univariate experimental design 
## with K = 3 categorical levels, J = 30 trials, I = 8 subjects
X1 <- generate_data(I=5,J=12,K=3,Z.formula="~Z1",M=50)

## Generate mouse-tracking data with two experimental factors Z1 and Z2, J = 9 trials, 
## K_Z1 = 3, K_Z2 = 3, I = 5 subjects
X2 <- generate_data(I=5,J=9,K=c(3,3),Z.formula="~Z1*Z2",
Z.type=c("symmetric","random"),M=50) # design with interaction
}
}
