% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_prior.R
\name{check_prior}
\alias{check_prior}
\title{Check prior distributions}
\usage{
check_prior(priors = NULL)
}
\arguments{
\item{priors}{(list) a list of arguments specifying priors for each parameter involved in the model (see Details). If \code{priors=NULL} then predefined vague priors will be returned.}
}
\value{
a matrix contatining priors (numeric codes, see Details) and their parameters
}
\description{
Check prior distributions
}
\details{
The function is used to specify the prior-related arguments of the state-space modeling function \code{\link{run_ssm}}. Priors are specified in terms of distributions and associated parameters as implemented in the \pkg{rstan} package.
The available options are as follows:
\itemize{
\item \code{lognormal(mu,sigma)} (code = 1, required parameters = 2)
\item \code{normal(mu,sigma)} (code = 2, required parameters = 2)
\item \code{normal(mu,sigma)T(min,max)} (code = 201, required parameters = at least 3)
\item \code{chi_square(df)} (code = 3, required parameters = 1)
\item \code{inv_chi_square(df)} (code = 4, required parameters = 1)
\item \code{gamma(alpha,beta)} (code = 5, required parameters = 2)
\item \code{pareto(min,alpha)} (code = 6, required parameters = 2)
\item \code{uniform(min,max)} (code = 7, required parameters = 2)
}
This is an internal function, generally not to be called by the user.
}
\examples{

\dontrun{
## Define priors for all the paramaters 
priors_list <- list("lognormal(1,1)","normal(2,3)T(0,10)","normal(3,1)")
priors_out <- check_prior(priors_list)
print(priors_out)

## Define priors for some of the paramaters 
priors_list <- list(NULL,"pareto(1,1.2)",NULL)
priors_out <- check_prior(priors_list)
print(priors_out)

## Use pre-defined vague priors for all the parameters
priors_list <- list(NULL,NULL,NULL)
priors_out <- check_prior(priors_list)
print(priors_out)
}
}
