% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsePCAloc_methods.R
\name{screeplot.PCAloc}
\alias{screeplot.PCAloc}
\title{Screeplot for PCAloc}
\usage{
\method{screeplot}{PCAloc}(x, ...)
}
\arguments{
\item{x}{object of class PCAloc.}

\item{...}{other input arguments, see details.}
}
\value{
Returns version of scree plot and cumulative explained variance per group for PCAloc object.
}
\description{
Screeplot for PCAloc
}
\details{
Additional parameters that can be given to the function are: \tabular{ll}{
   \code{text} \tab logical if text should be plotted  \cr
   \tab \cr
   \code{size} \tab text size \cr
   \tab \cr
   \code{cutoff} \tab cutoff line for scree plot  \cr
   \tab \cr
   \code{groupnames} \tab name of groups   \cr
   \tab \cr
    \code{textrotate} \tab angle of text, if text is plotted.   \cr
   \tab \cr
}
}
\examples{
# set seed
set.seed(236)
data = matrix(rnorm(2000), ncol = 4)
groups = sample(1:10, 500, replace = TRUE)
W = time_weights(N = 10, c(3,2,1))

# calculate covariance matrices
covs = ssMRCD(data, groups = groups, weights = W, lambda = 0.3)

# sparse PCA
pca = sparsePCAloc(eta = 0.3, gamma = 0.7, cor = FALSE, COVS = covs$MRCDcov,
             n_max = 1000, increase_rho = list(TRUE, 50, 1), trace = FALSE)

# plot biplot
screeplot(pca, text = TRUE, cutoff = 0.8, size = 2)
}
