% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case-parsing.r
\name{get_caseargs}
\alias{get_caseargs}
\title{Take a scenario ID and return argument lists}
\usage{
get_caseargs(folder, scenario, ext = ".txt", case_files = list(F = "F", D =
  c("index", "lcomp", "agecomp")))
}
\arguments{
\item{folder}{The folder to look for input files in.}

\item{scenario}{A character object that has the cases separated by the "-"
delimiter. The combination of cases and stock ID is referred to as a
scenario. E.g. \code{"D0-E0-F0-M0-R0-cod"}. See the Details section.}

\item{ext}{The file extension of the input files. Defaults to
\code{".txt"}.}

\item{case_files}{A named list that relates the case IDs (e.g. \code{"D"})
to the files to read the arguments from (e.g. \code{c("index", "lcomp",
"agecomp")}). See the Details section.}
}
\value{
A (nested) named list. The first level of the named list refers to
the \code{case_files}. The second level of the named list refers to the
argument names (the first column in the input text files). The contents of
the list are the argument values themselves (the second column of the input
text files).
}
\description{
This function calls a number of internal functions to go from a unique
scenario identifier like \code{"D1-E2-F3-M0-R4-cod"} and read the
corresponding input files (e.g. \code{"M0-cod.txt"}) that have two columns:
the first column contains the argument names and the second column contains
the argument values. The two columns should be separated by a semicolon.
The output is then returned in a named list with the intention of passing
these to \code{\link{run_ss3sim}} or \code{\link{ss3sim_base}}.
}
\details{
Let's start with an example scenario \code{"D0-E1-F0-M0-R0-cod"}.
The single capital letters refer to case IDs. The numbers refer to the case
numbers. The last block of text (\code{cod}) represents the stock ID (any
alphanumeric string of text will work) and is to help the user identify
different "stocks" (intended to represent different SS3 model setups).

The stock IDs should correspond to how the case files are named and the
case IDs should correspond to the cases described by the \code{case_files}.
The case file names will correspond to the list values plus the stock ID.
For example \code{list(D = c("index", "lcomp", "agecomp"))} combined with
the stock ID \code{cod} means that the case \code{D1} will refer to the
case files \code{index-cod.txt, lcomp-cod.txt, agecomp-cod.txt}.

The case argument plain text files should have arguments in the first
column that should be passed on to functions. The names should match
exactly. The second column (delimited by a semicolon) should contain the
values to be passed to those arguments. Multiple words should be enclosed
in quotes.

You can use any simple \R syntax to declare argument values. For example:
\code{c(1, 2, 4)}, or \code{seq(1, 100)}, or \code{1:100}, or
\code{matrix()}, or \code{NULL}. Character objects don't need to be quoted,
but can be if you'd like. However, be careful not to use the delimiter (set
up as a semicolon) anywhere else in the file besides to denote columns. You
can add comments after any \code{#} symbol just like in R.

Internally, the functions evaluate in \R any entries that have no
character values (e.g. \code{1:100}), or have an alpha-numeric character
followed by a \code{(}. Anything that is character only or has character
mixed with numeric but doesn't have the regular expression
\code{"[A-Za-z0-9]("} gets turned into a character argument. (\code{NA} and
\code{NULL} are special cases that are also passed on directly.)
}
\examples{
# Find the example data folders:
case_folder <- system.file("extdata", "eg-cases", package =
  "ss3sim")

# An example using the cases defined by default:
get_caseargs(case_folder, scenario = "D0-F0-cod")

# With a custom time-varying case for selectivity, which we'll call
# the S case. Here, we'll need to define which file the case S should
# read from ("S*-cod.txt"):
get_caseargs(case_folder, scenario = "D0-E0-F0-M0-R0-S0-cod",
  case_files = list(E = "E", D = c("index", "lcomp", "agecomp"), F =
    "F", M = "M", R = "retro", S = "S"))
}
