% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_ss3model.r
\name{run_ss3model}
\alias{run_ss3model}
\title{Run an operating or estimation model for a specified set of scenario IDs}
\usage{
run_ss3model(scenarios, iterations, type = c("om", "em"), admb_options = "",
  hess = FALSE, ignore.stdout = TRUE, admb_pause = 0.05,
  ss_mode = c("safe", "optimized"), show.output.on.console = FALSE, ...)
}
\arguments{
\item{scenarios}{Which scenarios to run. Controls which folder contains the
model that SS3 should run on.}

\item{iterations}{Which iterations to run. Controls which folder contains
the model that SS3 should run on.}

\item{type}{Are you running the operating or estimation models?}

\item{admb_options}{Any additional options to pass to the SS3 command.}

\item{hess}{Calculate the Hessian on estimation model runs?}

\item{ignore.stdout}{Passed to \code{system}. If \code{TRUE} then ADMB
output is not printed on screen. This will be slightly faster. Set to
\code{FALSE} to help with debugging.}

\item{admb_pause}{A length of time (in seconds) to pause after running the
simulation model. This can be necessary on certain computers where file
writing can be slightly delayed. For example, on computers where the files
are written over a network connection. If the output files haven't
finished writing before \R starts looking for the output then the
simulation will crash with an error about missing files. The default
value is set to \code{0.01} seconds, just to be safe.}

\item{ss_mode}{Which version of the SS3 executable should be run?
\code{"safe"} or \code{"optimized"}? Safe mode is useful for model building
and testing. Optimized will be slightly faster for running simulations.
Default is safe mode.}

\item{show.output.on.console}{Logical: passed on to
\code{\link[base]{system}}.}

\item{...}{Anything else to pass to \code{\link[base]{system}}.}
}
\description{
This function takes care of calling SS3. Importantly, it parses whether the
user is on Unix or Windows and calls the binary correctly. This lower-level
function is meant to be called by higher level functions such as
\code{\link{run_ss3sim}}, \code{\link{ss3sim_base}}, or your own custom
function.
}
\details{
ss3sim requires you to place the SS3 executable(s) in your
path. See the vignette \code{vignette("ss3sim-vignette")} for details on
this process. The executables themselves can be downloaded from:
\url{https://www.dropbox.com/sh/zg0sec6j20sfyyz/AACQiuk787qW882U2euVKoPna}

There are two versions of the executables: safe and optimized
(\code{opt}). Safe mode is best used during model development and testing.
Optimized mode will be slightly faster and can be used for simulation if
desired. The default is safe mode. \pkg{ss3sim} assumes that you at least
have the safe-mode SS3 binary in your path. If you wish to use optimized
mode then you must also have the \code{opt} executable version in your path.
These executables must be named exactly as they are at the link above. You
can choose the SS mode by setting the argument \code{ss_mode} to
\code{"safe"} or \code{"optimized"}.
}
\author{
Sean C. Anderson
}
\seealso{
\code{\link{ss3sim_base}}, \code{\link{run_ss3sim}}
}

