% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise.r
\name{summarise}
\alias{summarise}
\alias{summarize}
\title{Summarise multiple values to a single value.}
\usage{
summarise(.data, ...)
summarize(.data, ...)
}
\arguments{
\item{.data, }{tbl A \code{tbl_svy} object}

\item{...}{Name-value pairs of summary functions}
}
\description{
Summarise multiple values to a single value.
}
\details{
Summarise for \code{tbl_svy} objects accepts several specialized functions.
Each of the functions a variable (or two, in the case of
\code{survey_ratio}), from the data.frame and default to providing the measure
and its standard error.

The argument \code{vartype} can choose one or more measures of uncertainty,
\code{se} for standard error, \code{ci} for confidence interval, \code{var}
for variance, and \code{cv} for coefficient of variation. \code{level}
specifies the level for the confidence interval.

The other arguments correspond to the analagous function arguments from the
survey package.

The available functions from srvyr are:

\describe{
\item{\code{\link{survey_mean}}}{
   Calculate the survey mean of the entire population or by \code{groups}.
   Based on \code{\link[survey]{svymean}}.}
\item{\code{\link{survey_total}}}{
   Calculate the survey total of the entire population or by \code{groups}.
   Based on \code{\link[survey]{svytotal}}.}
 \item{\code{\link{survey_ratio}}}{
   Calculate the ratio of 2 variables in the entire population or by \code{groups}.
   Based on \code{\link[survey]{svyratio}}.}
\item{\code{\link{survey_quantile}}}{
   Calculate quantiles in the entire population or by \code{groups}. Based on
   \code{\link[survey]{svyquantile}}.}
 \item{\code{\link{survey_median}}}{
   Calculate the median in the entire population or by \code{groups}.
   \code{\link[survey]{svyquantile}}.}
 \item{\code{\link{unweighted}}}{
   Calculate an unweighted estimate as you would on a regular \code{tbl_df}.
   Based on dplyr's \code{\link[dplyr]{summarise}}.}
}
}
\examples{
library(survey)
data(api)

dstrata <- apistrat \%>\%
  as_survey_design(strata = stype, weights = pw)

dstrata \%>\%
  summarise(api99 = survey_mean(api99),
            api00 = survey_mean(api00),
            api_diff = survey_mean(api00 - api99))

dstrata_grp <- dstrata \%>\%
  group_by(stype)

dstrata_grp \%>\%
  summarise(api99 = survey_mean(api99),
            api00 = survey_mean(api00),
            api_diff = survey_mean(api00 - api99))

}
